#include "stdafx.h"        // Libreria precompilada
#include "VentanaMain.h"   // Esta clase
#include "resource.h"      // Recursos
//#include <commdlg.h>       // Common Diallog
//#include <commctrl.h>      // ListView y tal....
#include <DWLDialogosComunes.h>
#include <DWLArchivoBinario.h>
#include "..\zlib\zlib.h"
#include <wincrypt.h>

#define ID_EJECUTAR 5001



VentanaMain::VentanaMain(void) { // Constructor
//	Contador = 0;                   // Contador a 0
	EjecutarExe = false;            // Ejecutar exe a falso
	UltimClick = -1;                // Ultimo Item presionado a -1
	Menu.CrearMenu();
	Menu.CrearMenuItem(IDC_BUTTON2, TEXT("Borrar"));
	Menu.CrearMenuItem(IDC_BUTTON5, TEXT("Editar"));
	Menu.CrearMenuItem(ID_EJECUTAR, TEXT("Ejecutar al final"));



}

VentanaMain::~VentanaMain(void) { // Destructor
}                                 //

/*
BOOL CALLBACK VentanaMain::GestorMensajes(UINT uMsg, WPARAM wParam, LPARAM lParam) {
	switch (uMsg) {
		ENLACE_Evento_Cerrar();
		ENLACE_Evento_Comando();
		ENLACE_ListView_Evento_Mouse_Click();
		ENLACE_ListView_Evento_LabelEdit_Fin();
	}
	return DWL::Ventanas::DWLDialogo::GestorMensajes(uMsg, wParam, lParam);
}*/

// ..\Instalar.exe BubaTronik\Release\Instalador BubaTronik.exe
BOOL VentanaMain::Evento_ListView_LabelEdit_Fin(DWL::Controles::DWLListView_TerminarLabelEdit *Edicion, const UINT IDListView) {
	if (Filtro(Edicion->NuevoTexto()) == false) { // no es valido
		MessageBox(_hWnd, TEXT("El nombre introducido no puede tener los caracteres : '/' ':' '*' '?' '<' '>' '|'"), TEXT("Error"), MB_OK); // Muestro error
		Edicion->Cancelar = true;
	}
	else {
		if (Edicion->NuevoTexto[0] != TEXT('\\')) {
			DWL::DWLString Tmp = TEXT("\\"); Tmp += Edicion->NuevoTexto();
			Edicion->NuevoTexto = Tmp.Texto();
		}
		Archivos[Edicion->NumItem()].PathDest = Edicion->NuevoTexto();																							// Copio el path
	}
	return 0;
}


BOOL VentanaMain::Evento_ListView_Mouse_Click(const UINT Boton, const int cX, const int cY, const UINT IDListView) {
	if (Boton == 1) {
		Menu.Mostrar(_hWnd);
	}
	return 0;
}

void VentanaMain::MirarTXTClave(HKEY Root, TCHAR *Key, TCHAR *Nombre, TCHAR *Resultado, DWORD ResTam) {	//
	HKEY                hParentKey;                                                                     // Clave a abrir
	RegOpenKeyEx(Root, Key, 0, KEY_READ, &hParentKey);                                                  // Abro la clave especificada
	RegQueryValueEx(hParentKey, Nombre, 0, NULL, (BYTE *)Resultado , &ResTam);                          // Leo los datos de la clave
	RegCloseKey(hParentKey);                                                                            // Cierro la clave
}																										//    




bool VentanaMain::Filtro(const TCHAR *Text) {						//
	bool         R = true;											// Retorno
	unsigned int i = 0;												// Contador
	for (i = 0; i < DWLStrLen(Text); i++) {							// De 0 al tope de caracteres simo 1
		switch (Text[i]) {											// Miro el caracter
			case TEXT('/') :    case TEXT(':') :    case TEXT('*') :   case TEXT('?') :		// Si es uno de estos carcteres
			case TEXT('"') :    case TEXT('<') :    case TEXT('>') :   case TEXT('|') :		//
				R = false;											// Retorno a false
				break;												// Salgo del case
		}															// 
	}																//
	return R;														// Retorno el resultado
}																	//



void VentanaMain::Borrar(void) {							//
	for (int R = LV.TotalItems() -1; R != -1 ; R--) {		// De 0 al tope de items
		if (LV.Item(R)->Seleccionado() == true) {			// Obtengo el item
			Archivos.erase(Archivos.begin() + R);           // Borro el Archivo del array
			LV.BorrarItem(R);
			if (R == UltimClick) {							// Si el Item es el ejecutable
				EditExe.AsignarTexto(TEXT(""));
				UltimClick = -1;							// Asigno el Ejecutable a -1
			}												//
			else if (R < UltimClick) {						// Si el Item e mas pequeo que el ejecuablle
				UltimClick --;                                                                          // Resto uno al ejecutable
			}                                                                                           //
		}																								//
	}																									//
}																										//


void VentanaMain::Crear(void) {																							//
	CrearDialogo(IDD_DIALOG1, 100, 100);																			// Creo el dialogo
	LV.Asignar(_hWnd, IDC_LIST1);
	EditExe.Asignar(_hWnd, IDC_EDIT1);
	EditExe.Activado(false);
	EditPath.Asignar(_hWnd, IDC_EDIT2);
	EditExeSrc.Asignar(_hWnd, IDC_EDIT3);
	LV.AgregarColumna(TEXT("Path Original"), 350);
	LV.AgregarColumna(TEXT("Path Destino"), 350);
	Visible(true);                                                                                                  // Muestro el dialogo
	TCHAR Pt[512];                                                                                                   // String temporal
	GetCurrentDirectory(512, Pt);                                                                                   // Obtengo el directorio actual
	AppPath = Pt;                                                                                                   // Asingo el Directorioactual a AppPath
	EditPath.AsignarTexto(TEXT("\\\0"));
	DWL::DWLString PathSrc = Pt;
	PathSrc += TEXT("\\Instalar.dat");
	EditExeSrc.AsignarTexto(PathSrc());
	TCHAR ADP[512];                                                                                                  // String temporal 2
	MirarTXTClave(HKEY_LOCAL_MACHINE, TEXT("SOFTWARE\\Microsoft\\Windows\\CurrentVersion"), TEXT("ProgramFilesDir"), ADP, 512); // Obtengo el directorio "Archivos de Programa"
	ComboBox.Asignar(_hWnd, IDC_COMBO1);
	ComboBox.AgregarItem(TEXT("C:"));
	ComboBox.AgregarItem(ADP);	// Archivos de programa
	GetWindowsDirectory(ADP, 412);	                                                                       // Obtengo el directorio de windows
	ComboBox.AgregarItem(ADP);		// Windir

/*	ContenedorBinario Prueba;
	Prueba.AgregarParte("hola", 4);
	Prueba.AgregarParte("hola", 4);*/
}



void VentanaMain::LVAgregar(const TCHAR *Path) {      //
	DatosArchivo Tmp(Path, PathInicialDir.Texto());                               // Datos del archivo
	Archivos.push_back(Tmp);                          // Agrego el archivo
	
	LV.AgregarItem(0, Tmp.PathDest.Texto(), Tmp.Path.Texto());
}


BOOL VentanaMain::Evento_Comando(const int cID, const UINT CodigoNotificacion, HWND hWndControl) {  //
	switch (cID) {                                                                   // Miro la id del cntrol
		case IDC_BUTTON1 :                                                          // Boton aadir
			MostrarAbrir();                                                         // Muestro el dialogo para aadir archivos
			break;                                                                  // Salgo del case
		case IDC_BUTTON2 :                                                          // Boton borrar
			Borrar();                                                               // Borro el item
			break;                                                                  // Salgo del case
		case IDC_BUTTON3 :                                                          // Boton Crear instalacion
			CrearInst();                                                            // Creo la instalacion
			break;                                                                  // Salgo del case
		case IDC_BUTTON4 :                                                          // Boton Salir
			SendMessage(_hWnd, WM_CLOSE, 0, 0);                                     // Cierro la aplicacion
			break;                                                                  // Salgo del case
		case IDC_CHECK1 :                                                           // CheckBox del ejecutable
			EjecutarExe = !EjecutarExe;                                             // Canvio el flag a true o false
			break;                                                                  // Salgo del case
		case IDC_BUTTON5 :                                                          // Boton Salir
			LV.EmpezarLabelEdit(LV.Seleccion(), 0, false);
			break;
		case IDC_BUTTON6 :                                                          // Boton AadirDirs
			MostrarAbrirDirs();
			break;
		case IDC_BUTTON7 :
			AbrirProyecto();
			break;
		case IDC_BUTTON8 :
			GuardarProyecto();
			break;
		case ID_EJECUTAR :
			if (Archivos.size() > 0) {                                                                                               // Si hay algun archivo incluido
				UltimClick = LV.Seleccion();																						// Asigno ejecutable
				if (UltimClick > -1) {                                                                                              // Si el ejecutable es validp
					EditExe.AsignarTexto(Archivos[UltimClick].PathDest.Texto());
				}                                                                                                                   //    
			}                                                                                                                       //
			break;

	}                                                                               //
	return 0;
}                                                                                   //


void VentanaMain::GuardarProyecto(void) {
	DWL::Ventanas::DWLDialogoGuardar Guardar(TEXT("Selecciona donde deseas guardar"), TEXT("Proyecto Instalador (IPRJ)\0*.IPRJ"), TEXT("Guardar"));
	DWL::DWLString Final = Guardar.Archivo(); Final += TEXT(".IPRJ");
	DWL::Archivos::DWLArchivoBinario SV(Guardar.Archivo(), true);
	unsigned int Z = Archivos.size();
	SV.GuardarUnsignedInt(Z); // Total de archivos
	for (unsigned int i = 0; i < Archivos.size(); i++) {
		SV.GuardarString(Archivos[i].Path); // origen
		SV.GuardarString(Archivos[i].PathDest); // destino
	}
	SV.GuardarInt(UltimClick); // Seleccion para ejecutar
	SV.GuardarBool(EjecutarExe); // Si hay que ejecutar o no algo al final
	TCHAR Txt[512];
	EditExe.ObtenerTexto(Txt, 512);
	DWL::DWLString TMP = Txt;
	SV.GuardarString(TMP); // Ejecutable
	EditPath.ObtenerTexto(Txt, 512);
	TMP = Txt;
	SV.GuardarString(TMP); // Path
	ComboBox.ObtenerTexto(Txt, 512);
	TMP = Txt;
	SV.GuardarString(TMP); // Path destino inicial
	int CurSel = ComboBox.Seleccion();
	SV.GuardarInt(CurSel);

	EditExeSrc.ObtenerTexto(Txt, 512);
	TMP = Txt;
	SV.GuardarString(TMP); // Path ejecutable vacio

	SV.CerrarArchivo();
}

void VentanaMain::AbrirProyecto(void) {
	DWL::Ventanas::DWLDialogoAbrir Abrir(TEXT("Selecciona el proyecto"), TEXT("Proyecto Instalador (IPRJ)\0*.IPRJ"), TEXT("Abrir"));
	if (Abrir.TotalArchivos() == 0) return;
	DWL::Archivos::DWLArchivoBinario SV(Abrir.Archivos(0), false);
	if (SV.EstaAbierto() == false) return;
	LV.BorrarTodosLosItems();
	unsigned int Total = 0;
	DatosArchivo DT;
	SV.LeerUnsignedInt(Total);
	for (Total; Total != 0; Total --) {
		SV.LeerString(DT.Path);
		SV.LeerString(DT.PathDest);
		Archivos.push_back(DT);                          // Agrego el archivo
		LV.AgregarItem(0, DT.PathDest.Texto(), DT.Path.Texto());
	}
	SV.LeerInt(UltimClick); // Seleccion para ejecutar
	SV.LeerBool(EjecutarExe); // Si hay que ejecutar o no algo al final
	DWL::DWLString TMP;
	SV.LeerString(TMP); // Ejecutable
	EditExe.AsignarTexto(TMP.Texto());
	if (TMP.Tam() > 0) {
		EjecutarExe = true;// marco el check ejecutar
		SendMessage(GetDlgItem(_hWnd, IDC_CHECK1), BM_SETCHECK, BST_CHECKED, NULL);
	}
	else {
		EjecutarExe = true;// marco el check ejecutar
		SendMessage(GetDlgItem(_hWnd, IDC_CHECK1), BM_SETCHECK, BST_UNCHECKED, NULL);
	}


	SV.LeerString(TMP); // Path
	EditPath.AsignarTexto(TMP.Texto());
	
	SV.LeerString(TMP); // Path destino inicial
	ComboBox.AsignarTexto(TMP.Texto());
	int CurSel = 0;
	SV.LeerInt(CurSel);
	ComboBox.Seleccion(CurSel);

	SV.LeerString(TMP); // Path Instalador vacio
	EditExeSrc.AsignarTexto(TMP.Texto());
	//	CurSel = ComboBox.Seleccion();
	SV.CerrarArchivo();
}


void VentanaMain::MostrarAbrirDirs(void) {
	DWL::Ventanas::DWLDialogoDirectorios Dir;
	PathInicialDir = Dir.MostrarDirectorios(TEXT("Selecciona el directorio a aadir"));
	Escanear(PathInicialDir.Texto());
}


void VentanaMain::Escanear(const TCHAR *Path) {
	WIN32_FIND_DATA  FindInfoPoint;
	HANDLE           hFind     = NULL; 
	DWL::DWLString     PathFinal = Path;
	if (Path == NULL) return;
	if (PathFinal[PathFinal.Tam() -1] != TEXT('\\'))	PathFinal += TEXT("\\*.*");
	else												PathFinal += TEXT("*.*");
	hFind = FindFirstFile(PathFinal.Texto(), &FindInfoPoint);
	while (FindNextFile(hFind, &FindInfoPoint) != 0) {
		PathFinal = Path;
		if (PathFinal[PathFinal.Tam() -1] != TEXT('\\')) PathFinal += TEXT('\\');
		if (FindInfoPoint.cFileName[0] != TEXT('.')) { // Si es un archivo valido
			PathFinal += FindInfoPoint.cFileName;                                                                 
			if (FindInfoPoint.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY && FindInfoPoint.cFileName[0] != TEXT('.')) {	// Si es un subdirectorio lo reescaneo
				Escanear(PathFinal.Texto());																				//
			}
			else {
				LVAgregar(PathFinal.Texto());
			}
		}
	}
}




BOOL VentanaMain::Evento_Cerrar(void) { // Al cerrar la ventana
	PostQuitMessage(0);					// Termino la aplicacion
	return 0;							// Retorno 0
}										//



void VentanaMain::MirarDirs(void) {								// Funcion para obtener los directorios que se tendran que crear
	char          CD = 0;										// Contador
	unsigned char J;											// Contador 2
	DWL::DWLString  Tmp;											// String temporal
	Dirs.resize(0);
	for (unsigned int i = 0; i < Archivos.size(); i++) {		// De 0 al tope de archivos
		CD = 0;													// CD a 0
		for (J = 0; J < Archivos[i].PathDest.Tam(); J++) {		// De 0 al tope de caracteres del path
			if (Archivos[i].PathDest[J] == TEXT('\\')) {				// Si el caracter es "\\"
				CD ++;                                          // Sumo 1 al contador
				if (CD > 1) {                                   // Si el contador es mas grande que 1
					Tmp = Archivos[i].PathDest.SubStr(0, J);    // Asigno el directorio
					Dirs.push_back(Tmp);                        // Aado el directorioa la lista
				}                                               //
			}													//
		}														//
	}															//
}																// 

#define CHUNK 16384



const int VentanaMain::Comprimir2(DWL::Archivos::DWLArchivoBinario &Origen, ContenedorBinario &Destino) {
    int ret, flush;
    unsigned have;
    z_stream strm;
    char in[CHUNK];
    char out[CHUNK];

    // allocate deflate state 
    strm.zalloc = Z_NULL;
    strm.zfree = Z_NULL;
    strm.opaque = Z_NULL;
    ret = deflateInit(&strm, 5);
    if (ret != Z_OK) return ret;

	Origen.Posicion(0, false);

    // compress until end of file 
	do {
        strm.avail_in = Origen.Leer(&in, CHUNK * sizeof(char));
/*		if (Origen.Error() == true) {
            (void)deflateEnd(&strm);
            return Z_ERRNO;
        }*/
		flush = Origen.FinalDelArchivo() ? Z_FINISH : Z_NO_FLUSH;
//        flush = feof(source) ? Z_FINISH : Z_NO_FLUSH;
        strm.next_in = reinterpret_cast<Bytef *>(&in[0]);

        // run deflate() on input until output buffer not full, finish
        //   compression if all of source has been read in 
        do {
            strm.avail_out = CHUNK;
            strm.next_out = reinterpret_cast<Bytef *>(&out[0]);
            ret = deflate(&strm, flush);    // no bad return value 
            have = CHUNK - strm.avail_out;
			Destino.AgregarParte(out, have);
			/*if (Destino.Error() == true) {
                (void)deflateEnd(&strm);
		        return Z_ERRNO;
            }*/
        } while (strm.avail_out == 0);
	
	} while (flush != Z_FINISH);

    // clean up and return 
    (void)deflateEnd(&strm);
    return Z_OK;
}

/*
const int VentanaMain::Comprimir(DWL::Archivos::DWLArchivoBinario &Origen, DWL::Archivos::DWLArchivoBinario &Destino) {
    int ret, flush;
    unsigned have;
    z_stream strm;
    char in[CHUNK];
    char out[CHUNK];

    strm.zalloc = Z_NULL;
    strm.zfree = Z_NULL;
    strm.opaque = Z_NULL;
    ret = deflateInit(&strm, 5);
    if (ret != Z_OK) return ret;

	Origen.Posicion_Lectura(0, false);

	do {
        strm.avail_in = Origen.Leer(in, CHUNK);
		flush = Origen.FinalDelArchivo() ? Z_FINISH : Z_NO_FLUSH;
//        flush = feof(source) ? Z_FINISH : Z_NO_FLUSH;
        strm.next_in = reinterpret_cast<Bytef *>(&in[0]);

        do {
            strm.avail_out = CHUNK;
            strm.next_out = reinterpret_cast<Bytef *>(&out[0]);
            ret = deflate(&strm, flush);   
            have = CHUNK - strm.avail_out;
			Destino.Guardar(out, have);
        } while (strm.avail_out == 0);
	
	} while (flush != Z_FINISH);
    (void)deflateEnd(&strm);
    return Z_OK;
}*/


void VentanaMain::CrearInst(void) {                                                                                                                                                    // Funcion que creara el Instalador
	// Fase 1 :
	//  Comprobacion para determinar si se tienen todos los datos necesarios
	if (Archivos.size() == 0) {                                                                                                                                                        // Si no hay algun archivo
		MessageBox(_hWnd, TEXT("No hay ningun archivo para fusionar"), TEXT("Error"), MB_OK);                                                                                                        // Muestro el mensaje de error
		return;                                                                                                                                                                          // Salgo de la funcion
	}                                                                                                                                                                                 // 
	TCHAR Txt[512] = TEXT("");
	//ComboBox.ObtenerTexto(Txt, 512);
	//if (Txt[0] == '\0') {                                                                                                                                                                    // Si no es valido
	if (ComboBox.Seleccion() == -1) {
		MessageBox(_hWnd, TEXT("No has selecionado el directorio predefinido de instalacion"), TEXT("Error"), MB_OK);                                                                                // Muestro mensaje de error
		return;                                                                                                                                                                          // Salgo de la funcion
	}                                                                                                                                                                                 //
	if (EjecutarExe == true && UltimClick == -1) {                                                                                                                                    // Si hay un ejecutable pero no esta selecionado
		MessageBox(_hWnd, TEXT("No has selecionado ningun ejecutable. Selecionalo haciendo un dobleclick en la llista, o desseleciona la opcion de ejecutar un ejecutable."), TEXT("Error"), MB_OK); //
		return;                                                                                                                                                                          // Salgo de la funcion
	}                                                                                                                                                                                 //

	MirarDirs();
	// Fase 2 :
	//  Creacion de variables y archivos necesarios para el proceso
	//  Se leera todo el archivo Instalar.dat para saber su tamao y ademas para guardarlo
	EditExeSrc.ObtenerTexto(Txt, 512);
	DWL::DWLString	Org			= Txt;                                                                                                                                  // Path desino
	DWL::DWLString	Dest		= AppPath; Dest += TEXT("\\Instalar.exe");                                                                                                                                  // Path desino
//	TCHAR Txt[512];
	EditPath.ObtenerTexto(Txt, 512);
	DWL::DWLString  DestPath	= Txt;
	DWL::Archivos::DWLArchivoBinario	InstalarDat(Org.Texto(), false);						// Lectura
	DWL::Archivos::DWLArchivoBinario	InstalarExe(Dest.Texto(), true);						// Escritura
	DWL::Archivos::DWLArchivoBinario  Archivo;
//	unsigned long   TamArchivo;
	unsigned long   TamDat		= InstalarDat.Posicion(0, true);	// Obtengo el tamao del Dat
	if (InstalarDat.EstaAbierto() == false) {
		MessageBox(NULL, TEXT("No se ha encontrado el Instalador vacio!!"), TEXT("Creacion ABORTADA"), MB_OK);
		return;
	}
	char           *Tmp			= new char[TamDat];
	int				DirDef		= ComboBox.Seleccion();

	InstalarDat.Posicion(0, false);									// Vuelvo al inicio del archivo
	InstalarDat.Leer(Tmp, TamDat);											// Leo todo el Dat
	
	// Fase 3 Creacion e insercion de datos dentro de Instalar.exe
	InstalarExe.Guardar(Tmp, TamDat);										// Guardo todo el contenido de Instalar.dat dentro de Instalar.exe
	delete Tmp;																// Elimino Instalar.dat de la memoria
	InstalarExe.GuardarInt(DirDef);											// Guardo el directorio por defecto
	InstalarExe.GuardarString(DestPath);									// Guardo el nombre del directorio aadido al directorio por defecto

	unsigned int i = Dirs.size();											// Total de diractorios
	InstalarExe.GuardarUnsignedInt(i);										// Guardo el numero de directorios a crear
	for (; i > 0; i--) InstalarExe.GuardarString(Dirs[i -1]);				// Guardo los directorios a crear

	InstalarExe.GuardarBool(EjecutarExe);									// Guardo si hay que ejecutar algo
	if (EjecutarExe == true) {
		InstalarExe.GuardarString(Archivos[UltimClick].PathDest);			// Guardo el path del archivo que se va a ejecutar
	}
	i = Archivos.size();
	InstalarExe.GuardarUnsignedInt(i);										// Guardo el numero de archivos a insertar / extraer

	ContenedorBinario DatosArchivo;
	for (i = Archivos.size() -1; i != -1; i--) {							// Del tope de archivos a 0
		SOLO_DEBUG(DWL::DWLDebug::ImprimirDebug(TEXT("%s\n"), Archivos[i].Path.Texto()));
		Archivo.AbrirArchivo(Archivos[i].Path.Texto(), false);
		if (Archivo.EstaAbierto() != false) {
/*			TamArchivo = Archivo.Posicion_Lectura(0, true);
			Tmp = new char [TamArchivo];
			Archivo.Posicion_Lectura(0, false);
			Archivo.Leer(Tmp, TamArchivo);
			InstalarExe.GuardarString(Archivos[i].PathDest);					// Guardo Path final del archivo
			InstalarExe.GuardarUnsignedLong(TamArchivo);						// Guardo tamao del archivo
			InstalarExe.Guardar(Tmp, TamArchivo);								// Guardo el archivo
			delete Tmp;*/
//			Comprimir(Archivo, InstalarExe);
			Comprimir2(Archivo, DatosArchivo);
			InstalarExe.GuardarString(Archivos[i].PathDest);					// Guardo Path final del archivo
			InstalarExe.GuardarSizeT(DatosArchivo.Longitud());			// Guardo tamao del archivo
			InstalarExe.Guardar(&DatosArchivo._Datos[0], DatosArchivo.Longitud()); // MIRAR SI AHORA FUNCIONA BIEN
		}
		else {
			DatosArchivo.Borrar();
		}
		DatosArchivo.Borrar();
		Archivo.CerrarArchivo();
	}

	// Finalmente guardo en el final del archivo el tamao original de Instalar.dat, de esta forma sera mas facil moverse sin problemas.
	InstalarExe.GuardarUnsignedLong(TamDat);

	// Se guardan 4 bytes mas para asi saber si el instalador se ha creado ya o no.
	int Confirmacion = 3333;
	InstalarExe.GuardarInt(Confirmacion);

#define MD5LEN  16

	// Creo el archivo que contiene el HASH MD5 para el archivo Instalar.exe
	DWORD	sz = InstalarExe.Posicion(0, true);
	HCRYPTPROV hProv = 0,hHash = 0;
	BYTE	rgbHash[MD5LEN + 1] = { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
    DWORD	cbHash = 0;
    char	finalhash[33] = "", dig[] = "0123456789abcdef";
    BYTE   *hash = new BYTE[sz];
	size_t  l = 0;
	InstalarExe.Posicion(0, false);
	InstalarExe.Leer(hash, sz);

 	CryptAcquireContext(&hProv, NULL, NULL, PROV_RSA_FULL, CRYPT_VERIFYCONTEXT);
	CryptCreateHash(hProv, CALG_MD5, 0, 0, &hHash);
	CryptHashData(hHash, hash, sz, 0);
	cbHash = MD5LEN;
	BOOL RET = CryptGetHashParam(hHash, HP_HASHVAL, rgbHash, &cbHash, 0);
    for(DWORD i = 0; i < cbHash; i ++){
        finalhash[l] = dig[rgbHash[i] >> 4];
        l ++;
        finalhash[l] = dig[rgbHash[i] & 0xf];
        l ++;
    }
	     
    for(l = 32; l < strlen(finalhash); l++)	finalhash[l] = 0;
    CryptDestroyHash(hHash);
    CryptReleaseContext(hProv, 0);
	delete []hash;
	DWL::DWLString	DestHash = AppPath; DestHash += TEXT("\\Instalar.exe.hash");                                                                                                                                  // Path desino
	DWL::Archivos::DWLArchivoBinario ArchivoHash(DestHash(), true);
	ArchivoHash.Guardar(finalhash, l);


	MessageBox(NULL, TEXT("Instalar.exe creado!!"), TEXT("Creacion finalizada"), MB_OK);
}



void VentanaMain::MostrarAbrir(void) {
	DWL::Ventanas::DWLDialogoAbrir Abrir(NULL, TEXT("Todos los Archivos\0*.*\0Archivos de Texto\0*.TXT\0"), TEXT("Selecciona los archivos que deseas aadir"));
	PathInicialDir.Borrar();
	for (unsigned int i = 0; i < Abrir.TotalArchivos(); i++) {
		LVAgregar(Abrir[i]);
	}
}

